/*
 * Copyright 2003, 2004 Berend "Kirk" Wouda
 * 
 * This file is part of KirkPack.
 * 
 * KirkPack is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * KirkPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with KirkPack; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


// The package.
package kirk.util;

/**
 * This class represents an exception that can be thrown during the conversion of a
 * <code>String</code> to a <code>boolean</code> or <code>Boolean</code>.
 * 
 * @author Berend "Kirk" Wouda
 * @version 2.10
 * @since 2.00
 * @see java.lang.Boolean
 */
public class BooleanFormatException extends IllegalArgumentException {
	/**
	 * Constructs a new <code>BooleanFormatException</code> with the given message.
	 * 
	 * @param message The message that indicates what was wrong.
	 */
	public BooleanFormatException(String message) {
		// Super the message.
		super(message);
	}
	
	/**
	 * Constructs a new <code>BooleanFormatException</code> with no message.
	 */
	public BooleanFormatException() {
		// Super.
		super();
	}
}