/*
 * Copyright 2003, 2004 Berend "Kirk" Wouda
 * 
 * This file is part of KirkPack.
 * 
 * KirkPack is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * KirkPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with KirkPack; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


// Check out this class' package :^o
package kirk.io.sdl;

/**
 * This class represents an Structured Data Language document. It consists of an
 * <code>SDLElement</code> tree.
 * 
 * @author Berend "Kirk" Wouda
 * @version 2.10
 * @since 2.00
 * @see kirk.io.sdl.SDLReader
 * @see kirk.io.sdl.SDLElement
 */
public class SDLDocument {
	/**
	 * Constructs a new <code>SDLDocument</code> with the given version and root.
	 * 
	 * @param root The root element of this document.
	 */
	public SDLDocument(SDLElement root) {
		// Set the root element.
		setRoot(root);
	}
	

	/**
	 * Returns the root element of this document.
	 * 
	 * @return The root element of this document.
	 */
	public SDLElement getRoot() {
		return root;
	}

	/**
	 * Sets the root element of this document to <code>root</code>.
	 * 
	 * @param root The root element of this document.
	 */
	public void setRoot(SDLElement root) {
		this.root = root;
	}
	
	
	/**
	 * Returns a string representation of this SDL Document.
	 * 
	 * @return A string representation of this SDL Document.
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		// Retrieve the newline character(s) for the current OS.
		String nl = System.getProperty("line.separator");
		
		// The string.
		String string =
			"SDL Document:" + nl +
			" Root:" + nl +
			root.toString("  ");
		
		// Return t3h string.
		return string;
	}
	
	/**
	 * The root element of this document.
	 */
	protected SDLElement root;
}