/*
 * Copyright 2003, 2004 Berend "Kirk" Wouda
 * 
 * This file is part of KirkPack.
 * 
 * KirkPack is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * KirkPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with KirkPack; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


// The package.
package kirk.io.sdl;

/**
 * This class represents an exception that is thrown when there is no match while
 * searching for <code>SDLElement</code>s with a certain name.
 * 
 * @author Berend "Kirk" Wouda
 * @version 2.10
 * @since 2.00
 * @see kirk.io.sdl.SDLNormalElement#getElement(String)
 * @see kirk.io.sdl.SDLNormalElement#getNormalElement(String)
 * @see kirk.io.sdl.SDLNormalElement#getDataElement(String)
 */
public class NoMatchException extends Exception {
	/**
	 * Constructs a new <code>NoMatchException</code> with the given error message.
	 * 
	 * @param message The error message.
	 */
	public NoMatchException(String message) {
		// Superduper it.
		super(message);
	}
	
	/**
	 * Constructs a new <code>NoMatchException</code> with no error message.
	 */
	public NoMatchException() {
		// Superduper it.
		super();
	}	
}