/*
 * Copyright 2003, 2004 Berend "Kirk" Wouda
 * 
 * This file is part of KirkPack.
 * 
 * KirkPack is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * KirkPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with KirkPack; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


// The package.
package kirk.io.sdl;

/**
 * This class is an <code>Exception</code> that may be thrown during the reading of
 * an ESDL document. It indicates that the ESDL document is not correct.
 * 
 * @author Berend "Kirk" Wouda
 * @version 2.10
 * @since 2.00
 * @see kirk.io.sdl.SDLReader
 */
public class ESDLReadException extends Exception {
	/**
	 * Creates a new <code>ESDLReadException</code> with the given error message.
	 * 
	 * @param message The error message.
	 */
	public ESDLReadException(String message) {
		// Superduper it.
		super(message);
	}
	
	/**
	 * Creates a new <code>ESDLReadException</code>.
	 */
	public ESDLReadException() {
		// Superduper it.
		super();
	}
}