/*
 * Copyright 2003, 2004 Berend "Kirk" Wouda
 * 
 * This file is part of KirkPack.
 * 
 * KirkPack is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * KirkPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with KirkPack; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


// This class' package. Duh ;^)
package kirk.io;

/**
 * This <code>Exception</code> gets thrown if a write is attempted and it is not
 * allowed.
 * 
 * @author Berend "Kirk" Wouda
 * @version 2.10
 * @since 1.00
 * @see kirk.io.FileLineList
 */
public class WriteNotAllowedException extends Exception {
	/**
	 * Construct the <code>Exception</code> with a standard message.
	 */
	public WriteNotAllowedException() {
		// Tell the super class the error message.
		super("Writing is not supported in read only mode.");
	}
}