/*
 * Copyright 2003, 2004 Berend "Kirk" Wouda
 * 
 * This file is part of KirkPack.
 * 
 * KirkPack is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * KirkPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with KirkPack; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


// This class filters files, thus IO.
package kirk.io;

// Import the IO classes.
import java.io.*;

/**
 * This class is used for filtering out normal files when using
 * <code>java.io.File.listFiles(java.io.FileFilter)</code>.
 * 
 * @author Berend "Kirk" Wouda
 * @version 2.10
 * @since 2.00
 * @see java.io.File#list(java.io.FilenameFilter)
 */
public class NormalFileFilter implements FileFilter {
	/**
	 * Returns whether when the passed file should be included in the listing. If it
	 * is a normal file, it should.
	 * 
	 * @param file The file to be checked upon.
	 * @return Whether the file is a normal file.
	 */
	public boolean accept(File file) {
		// Return whether this file is a normal file.
		return file.isFile();
	}
}