/*
 * Copyright 2003, 2004 Berend "Kirk" Wouda
 * 
 * This file is part of KirkPack.
 * 
 * KirkPack is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * KirkPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with KirkPack; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


// Thine package.
package kirk.gui.dialog;

// Import Fraim.
import java.awt.Frame;

/**
 * <p>This class retrieves the value inputted in an <code>SingleInputDialog</code>.
 * </p>
 * 
 * <p>You retrieve the <code>String</code> with
 * <code>SingleInputRetriever.getInputValue(Frame owner, String message, int columns)
 * </code>.</p>
 * 
 * @author Berend "Kirk" Wouda
 * @version 2.10
 * @since 1.10
 * @see kirk.gui.dialog.SingleInputDialog
 */
public class SingleInputRetriever implements Retriever {
	/**
	 * Constructs a new <code>SingleInputRetriever</code>.
	 * 
	 * @param owner The <code>Frame</code> the dialog has to come on on.
	 * @param message The message to be displayed.
	 * @param columns The width of the input field in columns.
	 */
	protected SingleInputRetriever(Frame owner, String message, int columns) {
		// Pop up the Input dialog.
		SingleInputDialog inputdialog = new SingleInputDialog(owner, this, message, columns);
		
		// Show it.
		inputdialog.show();
	}
	
	
	/**
	 * Sets the input value to the passed value.
	 * Only the <code>InputDialog</code> that was constructed by this class should
	 * use this method.
	 * 
	 * @param inputdialog The value from the <code>InputDialog</code>.
	 */
	public boolean retrieve(InputDialog inputdialog) {
		// Retrieve the String from inputdialog (but cast it first). 
		value = ((SingleInputDialog) inputdialog).getValue();
		
		// Return true, to indicate that it can close.
		return true;
	}
	
	
	/**
	 * Returns the value retrieved from the <code>SingleInputDialog</code>. 
	 * 
	 * @return The value retrieved from the <code>SingleInputDialog</code>.
	 */
	protected String getValue() {
		// Return the value.
		return value;
	}
	
	
	/**
	 * Creates an <code>SingleInputRetriever</code> and retrieves its value.
	 * 
	 * @param owner The <code>Frame</code> a <code>Dialog</code> has to be popped up
	 * on. 
	 * @param message The message to be displayed on the popup.
	 * @param columns The amount of characters that have to fit in the input field.
	 * @return A <code>String</code> that contains the contents of the input field,
	 * or <code>null</code> if the input was canceled.
	 */
	public static String getValue(Frame owner, String message, int columns) {
		// Construct a new SingleInputRetriever.
		SingleInputRetriever retriever = new SingleInputRetriever(owner, message, columns);
		
		// Retrieve the value and return it.
		return retriever.getValue();
	}
	
	
	/**
	 * The value retrieved from the <code>InputDialog</code>.
	 */
	protected String value = null;
}