/*
 * Copyright 2003, 2004 Berend "Kirk" Wouda
 * 
 * This file is part of KirkPack.
 * 
 * KirkPack is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * KirkPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with KirkPack; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


// Zee Package.
package kirk.gui.dialog;

/**
 * This interface allows classes to retrieve the value(s) from an
 * <code>InputDialog</code>. It prescribes one method:
 * <code>public boolean retrieve(InputDialog inputdialog)</code>, which will be
 * called when the <code>InputDialog</code> is confirmed.
 * 
 * @author Berend "Kirk" Wouda
 * @version 2.10
 * @since 1.10
 * @see kirk.gui.dialog.InputDialog
 */
public interface Retriever {
	/**
	 * <p>The method that is called of the implementing <code>Retriever</code>.
	 * This method is generally used for retrieving the data from the passed
	 * <code>InputDialog</code> (after casting it to the correct subclass).
	 * If the data you retrieved was incorrect, you might want to return
	 * <code>false</code>, which indicates that the <code>InputDialog</code> should
	 * not close and bother the user some more, until he enters a correct value.
	 * If you wish to alert the user that the input was not valid, you can pop up
	 * another <code>PopupDialog</code>, on the active InputDialog (it is passed to
	 * retrieve() after all :) ). Alternatively, you could catch the
	 * <code>false</code> return in your custom <code>InputDialog</code> and make
	 * it display a message.<p>
	 * 
	 * <p>If you get <code>null</code> or similar values from the
	 * <code>InputDialog</code>, it might have been cancelled.</p>
	 * 
	 * @param inputdialog The <code>InputDialog</code> which the data should be
	 * retrieved of.
	 * @return <code>true</code> if the <code>InputDialog</code> should close,
	 * <code>false</code> if it should stay open.
	 */
	public boolean retrieve(InputDialog inputdialog);
}