/*
 * Copyright 2003, 2004 Berend "Kirk" Wouda
 * 
 * This file is part of KirkPack.
 * 
 * KirkPack is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * KirkPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with KirkPack; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


// Import this package. I mean... Uhm...
package kirk.gui.dialog;

// Import the AWT classes.
import java.awt.*;

// Import the LayoutManager this class uses.
import kirk.gui.layout.CenteredLineLayout;

/**
 * Pops up a <code>Dialog</code> with the given message, and a single button to close
 * it.
 * 
 * @author Berend "Kirk" Wouda
 * @version 2.10
 * @since 1.10
 */
public class MessageDialog extends PopupDialog {
	/**
	 * Constructs a new <code>MessageDialog</code> with the passed message. It
	 * rearranges the message to a more fitting use of space, if indicated.
	 * 
	 * @param owner The owner of this <code>Dialog</code>.
	 * @param title The title of this <code>Dialog</code>.
	 * @param message The message to be popped up.
	 * @param amount The amount of characters the message should be broken off at, or
	 * 0 if no breaking should occur.
	 */
	public MessageDialog(Frame owner, String title, String message, int amount) {
		// Call the superconstructor, with owner, and the passed title.
		super(owner, title);
		
		// Set the layout to CenteredLineLayout.
		setLayout(new CenteredLineLayout());

		// Check whether breaking should occur.
		if(amount > 0) {
			// Convert the message to an array of lines.
			String[] newmessage = convertMessage(message, amount);
							
			// Add a new Panel to put the labels on.
			Panel messagepanel = new Panel(new CenteredLineLayout(0, 0));
			add(messagepanel);
			
			// Add all the labels to the panel.
			for(int index = 0; index < newmessage.length; index++) {
				// Put this part of the message on a label and add it to the panel.
				Label messagelabel = new Label(newmessage[index], Label.CENTER);
				messagepanel.add(messagelabel);
			}
		}
		else {
			// Add a label with the message.
			Label messagelabel = new Label(message, Label.CENTER);
			add(messagelabel);
		}
		
		// Add an OK button to this Dialog. Make it close the window by generating an
		// ActionEvent.
		Button okbutton = new Button("OK");
		okbutton.setActionCommand("CLOSE");
		okbutton.addActionListener(this);
		add(okbutton);
	}
	
	/**
	 * Constructs a new <code>MessageDialog</code> with the passed message.
	 * 
	 * @param owner The owner of this <code>Dialog</code>.
	 * @param title The title of this <code>Dialog</code>.
	 * @param message The message to be popped up.
	 */
	public MessageDialog(Frame owner, String title, String message) {
		// Overload to the first constructor with a 0 value for the amount so that it
		// ignores it.
		this(owner, title, message, 0);
	}
}