/*
 * Copyright 2003, 2004 Berend "Kirk" Wouda
 * 
 * This file is part of KirkPack.
 * 
 * KirkPack is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * KirkPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with KirkPack; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


// Zee packaage.
package kirk.gui.dialog;

// Zee Frame.
import java.awt.Frame;

/**
 * Pops up an error <code>Dialog</code> with the given message, and a button to close
 * it.
 * 
 * @author Berend "Kirk" Wouda
 * @version 2.10
 * @since 1.10
 */
public class ErrorDialog extends MessageDialog {
	/**
	 * Construct a new <code>ErrorDialog</code> with the passed message and owner.
	 * 
	 * @param owner The owner of this <code>Dialog</code>.
	 * @param message The error message to be shown.
	 */
	public ErrorDialog(Frame owner, String message) {
		super(owner, "Error", message);
	}
}