/*
 * Copyright 2003, 2004 Berend "Kirk" Wouda
 * 
 * This file is part of KirkPack.
 * 
 * KirkPack is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * KirkPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with KirkPack; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


// t3h p4ck4g3.
package kirk.gui.closer;

// Import the GUI and event stuff.
import java.awt.*;
import java.awt.event.*;

/**
 * This class closes <code>Window</code>s that generate <code>WindowEvents</code>
 * asking for it. If specified, it can also end the program after the closing of a
 * <code>Window</code>. This is useful for main <code>Window</code>s.
 *
 * @author Berend Wouda
 * @version 2.10
 * @since 1.00
 * @see java.awt.Window
 */
public class WindowCloser extends WindowAdapter {
	/**
	 * Constructs a <code>WindowCloser</code> with the indicated setting for whether
	 * to exit the program after closing the window.
	 * 
	 * @param exit <code>true</code> if the program should exit after closing a
	 * window, <code>false</code> otherwise.
	 */
	public WindowCloser(boolean exit) {
		// Call the superconstructor.
		super();
		
		// Set whether we want to exit after closing.
		this.exit = exit;
	}
	
	/**
	 * Constructs a <code>WindowCloser</code> that does not end the program after
	 * closing.
	 */
	public WindowCloser() {
		// Overload the full constructor.
		this(false);
	}
	
	
	/**
	 * Closes the <code>Window</code> indicated by the given
	 * <code>WindowEvent</code>.
	 * 
	 * @param event The event that indicates which <code>Window</code> to close.
	 */
	public void windowClosing(WindowEvent event) {
		// Retrieve the Window.
		Window window = event.getWindow();
		
		// Hide the Window.
		window.setVisible(false);
		
		// Dump the Window.
		window.dispose();
		
		// End the program if required.
		if(exit)  System.exit(0);
	}
	
	
	/**
	 * Whether or not to exit after the window is closed. 
	 */
	protected boolean exit;
}