/*
 * Copyright 2003, 2004 Berend "Kirk" Wouda
 * 
 * This file is part of KirkPack.
 * 
 * KirkPack is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * KirkPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with KirkPack; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


// The pancake.
package kirk.gui.closer;

// Import the Window class.
import java.awt.Window; 

/**
 * This interface is implemented by classes wo want to make use of
 * <code>FinishingCloser</code>s for window closing. It provides a way to have
 * your program do things on exit.
 * 
 * @author Berend "Kirk" Wouda
 * @version 2.10
 * @since 2.00
 * @see kirk.gui.closer.FinishingCloser
 */
public interface Finisher {
	/**
	 * The method that gets called before a <code>FinishingCloser</code> closes
	 * a window.
	 * 
	 * @param window The <code>Window</code> that is being closed.
	 * @return <code>true</code> if the calling Window should be closed,
	 * <code>false</code> if it should not. 
	 */
	public boolean finish(Window window);
}