/*
 * Decompiled with CFR 0.152.
 */
package kirk.io.sdl;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import kirk.io.sdl.SDLDataElement;
import kirk.io.sdl.SDLDocument;
import kirk.io.sdl.SDLElement;
import kirk.io.sdl.SDLNormalElement;
import kirk.io.sdl.SDLWriteException;

public class SDLWriter {
    protected BufferedWriter writer;
    protected int position = 1;

    protected SDLWriter(OutputStream out) throws IOException {
        this.writer = new BufferedWriter(new OutputStreamWriter(out, "UTF-16"));
    }

    protected void writeSDLDocument(SDLDocument document) throws IOException, SDLWriteException {
        this.writeElement(document.getRoot());
    }

    protected void writeElement(SDLElement element) throws IOException, SDLWriteException {
        if (element instanceof SDLNormalElement) {
            this.writeNormalElement((SDLNormalElement)element);
        } else if (element instanceof SDLDataElement) {
            this.writeDataElement((SDLDataElement)element);
        } else {
            throw this.getException("SDLElement is of an unknown type.");
        }
    }

    protected void writeNormalElement(SDLNormalElement element) throws IOException, SDLWriteException {
        this.writeStartTag("element");
        this.writeFullTag("name", element.getName());
        this.writeStartTag("value");
        int index = 0;
        while (index < element.getNumberOfValues()) {
            this.writeElement(element.getValue(index));
            ++index;
        }
        this.writeEndTag("value");
        this.writeEndTag("element");
    }

    protected void writeDataElement(SDLDataElement element) throws IOException {
        this.writeStartTag("data");
        this.writeFullTag("name", element.getName());
        this.writeFullTag("value", element.getValue());
        this.writeEndTag("data");
    }

    protected void writeStartTag(String tagname) throws IOException {
        this.write("<" + tagname + ">");
    }

    protected void writeEndTag(String tagname) throws IOException {
        this.writeStartTag("/" + tagname);
    }

    protected void writeFullTag(String name, String value) throws IOException {
        this.writeStartTag(name);
        this.write(value);
        this.writeEndTag(name);
    }

    protected void write(String string) throws IOException {
        this.writer.write(string);
        this.position += string.length();
    }

    protected SDLWriteException getException(String error) {
        return new SDLWriteException("There is an error in the internal SDL description while writing on position " + this.position + ": " + error);
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void close() throws IOException {
        this.writer.close();
    }

    public static void writeSDL(SDLDocument document, OutputStream out) throws IOException, SDLWriteException {
        SDLWriter sdlwriter = new SDLWriter(out);
        sdlwriter.writeSDLDocument(document);
        sdlwriter.close();
    }

    public static void writeSDLFile(SDLDocument document, String filename) throws IOException, SDLWriteException {
        SDLWriter.writeSDL(document, new FileOutputStream(filename));
    }
}

