/*
 * Decompiled with CFR 0.152.
 */
package kirk.io.sdl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import kirk.io.sdl.SDLDataElement;
import kirk.io.sdl.SDLDocument;
import kirk.io.sdl.SDLElement;
import kirk.io.sdl.SDLNormalElement;
import kirk.io.sdl.SDLReadException;

public class SDLReader {
    protected BufferedReader reader;
    protected int position = 1;

    protected SDLReader(InputStream in) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader(in, "UTF-16"));
    }

    protected SDLDocument readSDLDocument() throws IOException, SDLReadException {
        SDLElement root = this.readElement();
        if (this.reader.read() == -1) {
            this.reader.close();
            return new SDLDocument(root);
        }
        throw this.getException("End of file expected.");
    }

    protected SDLElement readElement() throws IOException, SDLReadException {
        SDLElement element;
        String type;
        if (this.checkStartTag("element")) {
            type = "element";
            element = this.readNormalElement();
        } else if (this.checkStartTag("data")) {
            type = "data";
            element = this.readDataElement();
        } else {
            throw this.getException("<element> or <data> expected.");
        }
        if (this.checkEndTag(type)) {
            return element;
        }
        throw this.getException("<" + type + "> does not have a closing tag.");
    }

    protected SDLNormalElement readNormalElement() throws IOException, SDLReadException {
        String name = this.readTagValue("name");
        SDLNormalElement parent = new SDLNormalElement(name);
        if (this.checkStartTag("value")) {
            while (!this.checkEndTag("value")) {
                parent.addValue(this.readElement());
            }
            return parent;
        }
        throw this.getException("Opening tag <value> expected.");
    }

    protected SDLDataElement readDataElement() throws IOException, SDLReadException {
        return new SDLDataElement(this.readTagValue("name"), this.readTagValue("value"));
    }

    protected String readTagValue(String name) throws IOException, SDLReadException {
        if (this.checkStartTag(name)) {
            StringBuffer value = new StringBuffer();
            while (!this.checkEndTag(name)) {
                value.append(this.read());
            }
            return value.toString();
        }
        throw this.getException("Opening tag <" + name + "> expected.");
    }

    protected boolean checkStartTag(String tagname) throws IOException, SDLReadException {
        StringBuffer readtag = new StringBuffer();
        String tag = "<" + tagname + ">";
        this.reader.mark(tag.length());
        int count = 0;
        while (count < tag.length()) {
            readtag.append(this.read());
            ++count;
        }
        if (tag.equals(readtag.toString())) {
            return true;
        }
        this.reader.reset();
        this.position -= tag.length();
        return false;
    }

    protected boolean checkEndTag(String tagname) throws IOException, SDLReadException {
        tagname = "/" + tagname;
        return this.checkStartTag(tagname);
    }

    protected char read() throws IOException, SDLReadException {
        int readint = this.reader.read();
        ++this.position;
        if (readint > 0) {
            return (char)readint;
        }
        --this.position;
        throw this.getException("Preliminary end of file reached.");
    }

    protected SDLReadException getException(String error) {
        return new SDLReadException("There is an error in your SDL description at position " + this.position + ": " + error);
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void close() throws IOException {
        this.reader.close();
    }

    public static SDLDocument readSDL(InputStream in) throws IOException, SDLReadException {
        SDLReader sdlreader = new SDLReader(in);
        SDLDocument sdldocument = sdlreader.readSDLDocument();
        sdlreader.close();
        return sdldocument;
    }

    public static SDLDocument readSDLFile(String filename) throws IOException, SDLReadException {
        return SDLReader.readSDL(new FileInputStream(filename));
    }
}

