/*
 * Decompiled with CFR 0.152.
 */
package kirk.io.sdl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kirk.io.sdl.SDLDataElement;
import kirk.io.sdl.SDLElement;
import kirk.io.sdl.SDLNormalElement;

public class SDLNormalElementIterator
implements Iterator {
    protected SDLNormalElement element;
    protected String name;
    protected int elementtype;
    protected int counter = -1;
    public static final int BOTH = 0;
    public static final int NORMAL_ELEMENT = 1;
    public static final int DATA_ELEMENT = 2;

    public SDLNormalElementIterator(SDLNormalElement element, String name, int elementtype) throws IllegalArgumentException {
        if (element == null) {
            throw new IllegalArgumentException("The element to be iterated over cannot be null.");
        }
        this.element = element;
        this.name = name;
        if (elementtype < 0 || elementtype > 2) {
            throw new IllegalArgumentException("The element type is illegal.");
        }
        this.elementtype = elementtype;
    }

    public SDLNormalElementIterator(SDLNormalElement element, int elementtype) throws IllegalArgumentException {
        this(element, null, elementtype);
    }

    public SDLNormalElementIterator(SDLNormalElement element) throws IllegalArgumentException {
        this(element, null, 0);
    }

    public boolean hasNext() {
        boolean namematch = false;
        boolean typematch = false;
        int nextcounter = this.counter;
        while (nextcounter < this.element.getNumberOfValues() - 1) {
            SDLElement sdlelement = this.element.getValue(++nextcounter);
            namematch = this.name == null ? true : sdlelement.getName().equals(this.name);
            if (this.elementtype == 0) {
                typematch = sdlelement instanceof SDLNormalElement || sdlelement instanceof SDLDataElement;
            } else if (this.elementtype == 1) {
                typematch = sdlelement instanceof SDLNormalElement;
            } else if (this.elementtype == 2) {
                typematch = sdlelement instanceof SDLDataElement;
            }
            if (!namematch || !typematch) continue;
            return true;
        }
        return false;
    }

    public Object next() throws NoSuchElementException {
        if (this.hasNext()) {
            boolean namematch = false;
            boolean typematch = false;
            while (!namematch || !typematch) {
                ++this.counter;
                SDLElement sdlelement = this.element.getValue(this.counter);
                namematch = this.name == null ? true : sdlelement.getName().equals(this.name);
                if (this.elementtype == 0) {
                    typematch = sdlelement instanceof SDLNormalElement || sdlelement instanceof SDLDataElement;
                    continue;
                }
                if (this.elementtype == 1) {
                    typematch = sdlelement instanceof SDLNormalElement;
                    continue;
                }
                if (this.elementtype != 2) continue;
                typematch = sdlelement instanceof SDLDataElement;
            }
            return this.element.getValue(this.counter);
        }
        throw new NoSuchElementException("There were no more elements in the element with the name: " + this.element.getName());
    }

    public void remove() throws UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException("The remove() method of the SDLNormalElementIterator class is not supported.");
    }
}

