/*
 * Decompiled with CFR 0.152.
 */
package kirk.io.sdl;

import java.util.ArrayList;
import java.util.Iterator;
import kirk.io.sdl.MultipleMatchException;
import kirk.io.sdl.NoMatchException;
import kirk.io.sdl.SDLDataElement;
import kirk.io.sdl.SDLElement;
import kirk.io.sdl.SDLNormalElementIterator;

public class SDLNormalElement
extends SDLElement {
    protected ArrayList valuelist = new ArrayList();
    public static final String IDENTIFIER = "element";

    public SDLNormalElement(String name) {
        super(name);
    }

    public SDLElement getValue(int index) {
        return (SDLElement)this.valuelist.get(index);
    }

    public void addValue(int index, SDLElement value) {
        if (value == null) {
            throw new NullPointerException("Added values cannot be null.");
        }
        this.valuelist.add(index, value);
    }

    public void addValue(SDLElement value) {
        if (value == null) {
            throw new NullPointerException("Added values cannot be null.");
        }
        this.valuelist.add(value);
    }

    public void setValue(SDLElement value, int index) {
        if (value == null) {
            throw new NullPointerException("Set values cannot be null.");
        }
        this.valuelist.set(index, value);
    }

    public SDLElement removeValue(int index) {
        return (SDLElement)this.valuelist.remove(index);
    }

    public SDLElement removeValue(SDLElement value) {
        if (value != null) {
            if (this.valuelist.remove(value)) {
                return value;
            }
            throw new IllegalArgumentException("The value to be removed is not present.");
        }
        throw new NullPointerException("Removed values cannot be null.");
    }

    public int getNumberOfValues() {
        return this.valuelist.size();
    }

    public Iterator getElements() {
        return new SDLNormalElementIterator(this, 0);
    }

    public Iterator getElements(String name) {
        return new SDLNormalElementIterator(this, name, 0);
    }

    public Iterator getNormalElements() {
        return new SDLNormalElementIterator(this, 1);
    }

    public Iterator getNormalElements(String name) {
        return new SDLNormalElementIterator(this, name, 1);
    }

    public Iterator getDataElements() {
        return new SDLNormalElementIterator(this, 2);
    }

    public Iterator getDataElements(String name) {
        return new SDLNormalElementIterator(this, name, 2);
    }

    public SDLElement getElement(String name) throws MultipleMatchException, NoMatchException {
        Iterator elements = this.getElements(name);
        if (elements.hasNext()) {
            SDLElement element = (SDLElement)elements.next();
            if (elements.hasNext()) {
                throw new MultipleMatchException("There were multiple matches while searching for an element with " + name + " as name.");
            }
            return element;
        }
        throw new NoMatchException("There was no match while searching for an element with " + name + " as name.");
    }

    public SDLNormalElement getNormalElement(String name) throws MultipleMatchException, NoMatchException {
        Iterator elements = this.getNormalElements(name);
        if (elements.hasNext()) {
            SDLNormalElement element = (SDLNormalElement)elements.next();
            if (elements.hasNext()) {
                throw new MultipleMatchException("There were multiple matches while searching for a normal element with " + name + " as name.");
            }
            return element;
        }
        throw new NoMatchException("There was no match while searching for a normal element with " + name + " as name.");
    }

    public SDLDataElement getDataElement(String name) throws MultipleMatchException, NoMatchException {
        Iterator elements = this.getDataElements(name);
        if (elements.hasNext()) {
            SDLDataElement element = (SDLDataElement)elements.next();
            if (elements.hasNext()) {
                throw new MultipleMatchException("There were multiple matches while searching for a data element with " + name + " as name.");
            }
            return element;
        }
        throw new NoMatchException("There was no match while searching for a data element with " + name + " as name.");
    }

    public String toString(String indent) {
        String nl = System.getProperty("line.separator");
        String string = String.valueOf(indent) + "Normal Element:" + nl + indent + " Name: " + this.getName() + nl + indent + " Value: " + nl;
        int index = 0;
        while (index < this.getNumberOfValues()) {
            string = String.valueOf(string) + this.getValue(index).toString(String.valueOf(indent) + "  ");
            ++index;
        }
        return string;
    }
}

