/*
 * Decompiled with CFR 0.152.
 */
package kirk.io.sdl;

import kirk.io.sdl.SDLElement;
import kirk.util.BooleanFormatException;
import kirk.util.CharacterFormatException;

public class SDLDataElement
extends SDLElement {
    protected String value;
    public static final String IDENTIFIER = "data";

    public SDLDataElement(String name, String value) {
        super(name);
        this.setValue(value);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String getValueAsString() {
        return this.value;
    }

    public StringBuffer getValueAsStringBuffer() {
        return new StringBuffer(this.value);
    }

    public Character getValueAsCharacter() throws CharacterFormatException {
        if (this.value.length() == 1) {
            return new Character(this.value.charAt(0));
        }
        throw new CharacterFormatException("The data value is not a single character: " + this.value);
    }

    public Byte getValueAsByte() throws NumberFormatException {
        return new Byte(this.value);
    }

    public Short getValueAsShort() throws NumberFormatException {
        return new Short(this.value);
    }

    public Integer getValueAsInteger() throws NumberFormatException {
        return new Integer(this.value);
    }

    public Long getValueAsLong() throws NumberFormatException {
        return new Long(this.value);
    }

    public Float getValueAsFloat() throws NumberFormatException {
        return new Float(this.value);
    }

    public Double getValueAsDouble() throws NumberFormatException {
        return new Double(this.value);
    }

    public Boolean getValueAsBoolean() throws BooleanFormatException {
        if (this.value.equalsIgnoreCase("true")) {
            return new Boolean(true);
        }
        if (this.value.equalsIgnoreCase("false")) {
            return new Boolean(false);
        }
        throw new BooleanFormatException("The data value is not a boolean: " + this.value);
    }

    public String toString(String indent) {
        String nl = System.getProperty("line.separator");
        String string = String.valueOf(indent) + "Data Element:" + nl + indent + " Name: " + this.getName() + nl + indent + " Value: " + this.getValue() + nl;
        return string;
    }
}

