/*
 * Decompiled with CFR 0.152.
 */
package kirk.io.sdl;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import kirk.io.sdl.ESDLWriteException;
import kirk.io.sdl.SDLDataElement;
import kirk.io.sdl.SDLDocument;
import kirk.io.sdl.SDLElement;
import kirk.io.sdl.SDLNormalElement;

public class ESDLWriter {
    protected BufferedWriter writer;
    protected int position = 1;

    protected ESDLWriter(OutputStream out) throws IOException {
        this.writer = new BufferedWriter(new OutputStreamWriter(out, "UTF-16"));
    }

    protected void writeSDLDocument(SDLDocument document) throws IOException, ESDLWriteException {
        this.writeElement(0, document.getRoot());
    }

    protected void writeElement(int indentation, SDLElement element) throws IOException, ESDLWriteException {
        if (element instanceof SDLNormalElement) {
            this.writeNormalElement(indentation, (SDLNormalElement)element);
        } else if (element instanceof SDLDataElement) {
            this.writeDataElement(indentation, (SDLDataElement)element);
        } else {
            throw this.getException("SDLElement is of an unknown type.");
        }
    }

    protected void writeNormalElement(int indentation, SDLNormalElement element) throws IOException, ESDLWriteException {
        this.writeStartTag(indentation, "element", true);
        this.writeFullTag(indentation + 1, "name", element.getName());
        this.writeStartTag(indentation + 1, "value", true);
        int index = 0;
        while (index < element.getNumberOfValues()) {
            this.writeElement(indentation + 2, element.getValue(index));
            ++index;
        }
        this.writeEndTag(indentation + 1, "value");
        this.writeEndTag(indentation, "element");
    }

    protected void writeDataElement(int indentation, SDLDataElement element) throws IOException {
        this.writeStartTag(indentation, "data", true);
        this.writeFullTag(indentation + 1, "name", element.getName());
        this.writeFullTag(indentation + 1, "value", element.getValue());
        this.writeEndTag(indentation, "data");
    }

    protected void writeStartTag(int indentation, String tagname, boolean newline) throws IOException {
        this.writeLine(indentation, "<" + tagname + ">", newline);
    }

    protected void writeEndTag(int indentation, String tagname) throws IOException {
        this.writeStartTag(indentation, "/" + tagname, true);
    }

    protected void writeFullTag(int indentation, String name, String value) throws IOException {
        this.writeStartTag(indentation, name, false);
        this.write(value);
        this.writeEndTag(0, name);
    }

    protected void writeLine(int indentation, String string, boolean newline) throws IOException {
        int count = 0;
        while (count < indentation) {
            this.writeTab();
            ++count;
        }
        this.write(string);
        if (newline) {
            this.writeNewLine();
        }
    }

    protected void writeNewLine() throws IOException {
        this.write("\n");
    }

    protected void writeTab() throws IOException {
        this.write("\t");
    }

    protected void write(String string) throws IOException {
        this.writer.write(string);
        this.position += string.length();
    }

    protected ESDLWriteException getException(String error) {
        return new ESDLWriteException("There is an error in the internal SDL description while writing on position " + this.position + ": " + error);
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void close() throws IOException {
        this.writer.close();
    }

    public static void writeESDL(SDLDocument document, OutputStream out) throws IOException, ESDLWriteException {
        ESDLWriter sdlwriter = new ESDLWriter(out);
        sdlwriter.writeSDLDocument(document);
        sdlwriter.close();
    }

    public static void writeESDLFile(SDLDocument document, String filename) throws IOException, ESDLWriteException {
        ESDLWriter.writeESDL(document, new FileOutputStream(filename));
    }
}

