/*
 * Decompiled with CFR 0.152.
 */
package kirk.io.sdl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import kirk.io.sdl.ESDLReadException;
import kirk.io.sdl.SDLDataElement;
import kirk.io.sdl.SDLDocument;
import kirk.io.sdl.SDLElement;
import kirk.io.sdl.SDLNormalElement;

public class ESDLReader {
    protected BufferedReader reader;
    protected int position = 1;

    protected ESDLReader(InputStream in) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader(in, "UTF-16"));
    }

    protected SDLDocument readESDLDocument() throws IOException, ESDLReadException {
        SDLElement root = this.readElement();
        this.skipWhiteSpaceAndComments();
        if (this.reader.read() == -1) {
            this.reader.close();
            return new SDLDocument(root);
        }
        throw this.getException("End of file expected.");
    }

    protected SDLElement readElement() throws IOException, ESDLReadException {
        SDLElement element;
        String type;
        this.skipWhiteSpaceAndComments();
        if (this.checkStartTag("element")) {
            type = "element";
            element = this.readNormalElement();
        } else if (this.checkStartTag("data")) {
            type = "data";
            element = this.readDataElement();
        } else {
            throw this.getException("<element> or <data> expected.");
        }
        this.skipWhiteSpaceAndComments();
        if (this.checkEndTag(type)) {
            return element;
        }
        throw this.getException("<" + type + "> does not have a closing tag.");
    }

    protected SDLNormalElement readNormalElement() throws IOException, ESDLReadException {
        this.skipWhiteSpaceAndComments();
        String name = this.readTagValue("name");
        SDLNormalElement parent = new SDLNormalElement(name);
        this.skipWhiteSpaceAndComments();
        if (this.checkStartTag("value")) {
            this.skipWhiteSpaceAndComments();
            while (!this.checkEndTag("value")) {
                parent.addValue(this.readElement());
                this.skipWhiteSpaceAndComments();
            }
            return parent;
        }
        throw this.getException("Opening tag <value> expected.");
    }

    protected SDLDataElement readDataElement() throws IOException, ESDLReadException {
        this.skipWhiteSpaceAndComments();
        return new SDLDataElement(this.readTagValue("name"), this.readTagValue("value"));
    }

    private String readTagValue(String name) throws IOException, ESDLReadException {
        this.skipWhiteSpaceAndComments();
        if (this.checkStartTag(name)) {
            StringBuffer value = new StringBuffer();
            while (!this.checkEndTag(name)) {
                value.append(this.read());
            }
            return value.toString();
        }
        throw this.getException("Opening tag <" + name + "> expected.");
    }

    protected void skipWhiteSpaceAndComments() throws IOException, ESDLReadException {
        this.reader.mark(1);
        try {
            while ("\n\r\t\f ".indexOf(this.read()) >= 0) {
                this.reader.mark(1);
            }
        }
        catch (ESDLReadException e) {
            return;
        }
        this.reader.reset();
        --this.position;
        boolean iscomment = false;
        int tempposition = this.position;
        try {
            iscomment = this.checkStartTag("comment");
        }
        catch (ESDLReadException e) {
            this.reader.reset();
            this.position = tempposition;
            return;
        }
        if (iscomment) {
            while (!this.checkEndTag("comment")) {
                this.read();
            }
        } else {
            return;
        }
        this.skipWhiteSpaceAndComments();
    }

    protected boolean checkStartTag(String tagname) throws IOException, ESDLReadException {
        StringBuffer readtag = new StringBuffer();
        String tag = "<" + tagname + ">";
        this.reader.mark(tag.length());
        int count = 0;
        while (count < tag.length()) {
            readtag.append(this.read());
            ++count;
        }
        if (tag.equals(readtag.toString())) {
            return true;
        }
        this.reader.reset();
        this.position -= tag.length();
        return false;
    }

    protected boolean checkEndTag(String tagname) throws IOException, ESDLReadException {
        tagname = "/" + tagname;
        return this.checkStartTag(tagname);
    }

    protected char read() throws IOException, ESDLReadException {
        int readint = this.reader.read();
        ++this.position;
        if (readint > 0) {
            return (char)readint;
        }
        --this.position;
        throw this.getException("Preliminary end of file reached.");
    }

    protected ESDLReadException getException(String error) {
        return new ESDLReadException("There is an error in your ESDL description at position " + this.position + ": " + error);
    }

    public void finalize() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static SDLDocument readESDLFile(String filename) throws IOException, ESDLReadException {
        ESDLReader sdlreader = new ESDLReader(new FileInputStream(filename));
        return sdlreader.readESDLDocument();
    }

    public static SDLDocument readESDL(InputStream in) throws IOException, ESDLReadException {
        ESDLReader sdlreader = new ESDLReader(in);
        return sdlreader.readESDLDocument();
    }
}

