/*
 * Decompiled with CFR 0.152.
 */
package kirk.io;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class FileTokenizer {
    protected String currenttoken;
    protected String currentline;
    protected String nextline;
    protected String delimiters;
    protected boolean returndelims;
    protected BufferedReader reader;
    protected StringTokenizer tokenizer;

    public FileTokenizer(String file, String delims, boolean delimtokens) throws IOException {
        this.reader = new BufferedReader(new FileReader(file));
        this.delimiters = delims;
        this.returndelims = delimtokens;
        this.nextLine();
        this.nextLine();
    }

    public FileTokenizer(String file, String delims) throws IOException {
        this(file, delims, false);
    }

    public FileTokenizer(String file, boolean delimtokens) throws IOException {
        this(file, " ", delimtokens);
    }

    public FileTokenizer(String file) throws IOException {
        this(file, " ", false);
    }

    public void close() throws IOException {
        this.reader.close();
    }

    protected void nextLine() throws IOException {
        this.currentline = this.nextline;
        do {
            this.nextline = this.reader.readLine();
        } while (this.nextline != null && this.nextline.equals(""));
        this.tokenizer = this.currentline != null ? new StringTokenizer(this.currentline, this.delimiters, this.returndelims) : null;
    }

    public String nextToken() throws IOException {
        if (this.tokenizer != null) {
            if (this.tokenizer.hasMoreTokens()) {
                this.currenttoken = this.tokenizer.nextToken();
            } else {
                this.nextLine();
                this.nextToken();
            }
            return this.currenttoken;
        }
        this.currenttoken = null;
        return this.currenttoken;
    }

    public String currentToken() {
        return this.currenttoken;
    }

    public String getTokenAsString() {
        return this.currenttoken;
    }

    public Byte getTokenAsByte() {
        try {
            return new Byte(this.currenttoken);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Character getTokenAsCharacter() {
        if (this.currenttoken.length() == 1) {
            return new Character(this.currenttoken.charAt(0));
        }
        return null;
    }

    public Double getTokenAsDouble() {
        try {
            return new Double(this.currenttoken);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Float getTokenAsFloat() {
        try {
            return new Float(this.currenttoken);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Integer getTokenAsInteger() {
        try {
            return new Integer(this.currenttoken);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Long getTokenAsLong() {
        try {
            return new Long(this.currenttoken);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Short getTokenAsShort() {
        try {
            return new Short(this.currenttoken);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public boolean fileHasMoreTokens() {
        if (this.lineHasMoreTokens()) {
            return true;
        }
        return this.nextline != null;
    }

    public boolean lineHasMoreTokens() {
        if (this.tokenizer != null) {
            return this.tokenizer.hasMoreTokens();
        }
        return false;
    }

    public boolean firstToken() {
        StringTokenizer st = new StringTokenizer(this.currentline, this.delimiters, this.returndelims);
        if (this.tokenizer != null) {
            return st.countTokens() == this.tokenizer.countTokens() + 1;
        }
        return false;
    }

    public boolean lastToken() {
        if (this.tokenizer != null) {
            return !this.tokenizer.hasMoreElements();
        }
        return false;
    }
}

