/*
 * Decompiled with CFR 0.152.
 */
package kirk.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import kirk.gui.layout.LineLayout;

public class VariableLineLayout
extends LineLayout {
    public VariableLineLayout(int horizontalgap, int verticalgap) {
        super(horizontalgap, verticalgap);
    }

    public VariableLineLayout(int verticalgap) {
        super(verticalgap);
    }

    public VariableLineLayout() {
    }

    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            int index = 0;
            while (index < parent.getComponentCount()) {
                if (parent.getComponent(index).isVisible()) {
                    dimension.height += parent.getComponent((int)index).getPreferredSize().height + this.getVerticalGap();
                }
                ++index;
            }
            Insets insets = parent.getInsets();
            dimension.height += this.getVerticalGap() + insets.top + insets.bottom;
            dimension.width = this.getPreferredWidth(parent);
            return dimension;
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            int index = 0;
            while (index < parent.getComponentCount()) {
                if (parent.getComponent(index).isVisible()) {
                    dimension.height += parent.getComponent((int)index).getMinimumSize().height + this.getVerticalGap();
                }
                ++index;
            }
            Insets insets = parent.getInsets();
            dimension.height += this.getVerticalGap() + insets.top + insets.bottom;
            dimension.width = this.getMinimumWidth(parent);
            return dimension;
        }
    }

    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int top = insets.top + this.getVerticalGap();
            int left = insets.left + this.getHorizontalGap();
            int index = 0;
            while (index < parent.getComponentCount()) {
                Component component = parent.getComponent(index);
                if (component.isVisible()) {
                    int width = this.getWidth(parent, component);
                    int height = component.getPreferredSize().height;
                    component.setBounds(left, top, width, height);
                    top += height + this.getVerticalGap();
                }
                ++index;
            }
        }
    }
}

