/*
 * Decompiled with CFR 0.152.
 */
package kirk.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import kirk.gui.layout.LineLayout;

public class LargestLineLayout
extends LineLayout {
    public LargestLineLayout(int horizontalgap, int verticalgap) {
        super(horizontalgap, verticalgap);
    }

    public LargestLineLayout(int verticalgap) {
        super(verticalgap);
    }

    public LargestLineLayout() {
    }

    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            return new Dimension(this.getPreferredWidth(parent), parent.getComponentCount() * this.getLargestPreferredHeight(parent) + 2 * this.getVerticalGap() + insets.top + insets.bottom);
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            return new Dimension(this.getMinimumWidth(parent), parent.getComponentCount() * this.getLargestMinimumHeight(parent) + 2 * this.getVerticalGap() + insets.top + insets.bottom);
        }
    }

    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int placement = insets.top + this.getVerticalGap();
            int left = insets.left + this.getHorizontalGap();
            int cellheight = this.getLargestPreferredHeight(parent);
            int index = 0;
            while (index < parent.getComponentCount()) {
                Component component = parent.getComponent(index);
                if (component.isVisible()) {
                    int width = this.getWidth(parent, component);
                    int height = Math.min(component.getPreferredSize().height, cellheight);
                    int top = placement + (cellheight - height) / 2;
                    component.setBounds(left, top, width, height);
                    placement += cellheight + this.getVerticalGap();
                }
                ++index;
            }
        }
    }

    public int getLargestPreferredHeight(Container parent) {
        int largestheight = 0;
        int index = 0;
        while (index < parent.getComponentCount()) {
            if (parent.getComponent(index).isVisible()) {
                largestheight = Math.max(largestheight, parent.getComponent((int)index).getPreferredSize().height);
            }
            ++index;
        }
        return largestheight;
    }

    public int getLargestMinimumHeight(Container parent) {
        int largestheight = 0;
        int index = 0;
        while (index < parent.getComponentCount()) {
            if (parent.getComponent(index).isVisible()) {
                largestheight = Math.max(largestheight, parent.getComponent((int)index).getMinimumSize().height);
            }
            ++index;
        }
        return largestheight;
    }
}

