/*
 * Decompiled with CFR 0.152.
 */
package kirk.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import kirk.gui.layout.LineLayout;

public class FixedLineLayout
extends LineLayout {
    protected int height;

    public FixedLineLayout(int height, int horizontalgap, int verticalgap) {
        super(horizontalgap, verticalgap);
        this.setHeight(height);
    }

    public FixedLineLayout(int height, int verticalgap) {
        super(verticalgap);
        this.setHeight(height);
    }

    public FixedLineLayout(int height) {
        this.setHeight(height);
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            return new Dimension(this.getPreferredWidth(parent), parent.getComponentCount() * this.getHeight() + 2 * this.getVerticalGap() + insets.top + insets.bottom);
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        Dimension dimension = this.preferredLayoutSize(parent);
        Object object = parent.getTreeLock();
        synchronized (object) {
            dimension.width = this.getMinimumWidth(parent);
        }
        return dimension;
    }

    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int placement = insets.top + this.getVerticalGap();
            int left = insets.left + this.getHorizontalGap();
            int index = 0;
            while (index < parent.getComponentCount()) {
                Component component = parent.getComponent(index);
                if (component.isVisible()) {
                    int width = this.getWidth(parent, component);
                    int height = Math.min(component.getPreferredSize().height, this.getHeight());
                    int top = placement + (this.getHeight() - height) / 2;
                    component.setBounds(left, top, width, height);
                    placement += this.getHeight() + this.getVerticalGap();
                }
                ++index;
            }
        }
    }
}

