/*
 * Decompiled with CFR 0.152.
 */
package kirk.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import kirk.gui.layout.VariableLineLayout;

public class CenteredLineLayout
extends VariableLineLayout {
    public CenteredLineLayout(int horizontalgap, int verticalgap) {
        super(horizontalgap, verticalgap);
    }

    public CenteredLineLayout(int verticalgap) {
        super(verticalgap);
    }

    public CenteredLineLayout() {
    }

    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int top = insets.top + this.getVerticalGap();
            int left = insets.left + this.getHorizontalGap();
            int right = insets.right + this.getHorizontalGap();
            int index = 0;
            while (index < parent.getComponentCount()) {
                Component component = parent.getComponent(index);
                if (component.isVisible()) {
                    int width = component.getPreferredSize().width;
                    int height = component.getPreferredSize().height;
                    int placement = left + (parent.getWidth() - left - right - width) / 2;
                    component.setBounds(placement, top, width, height);
                    top += height + this.getVerticalGap();
                }
                ++index;
            }
        }
    }
}

