/*
 * Decompiled with CFR 0.152.
 */
package kirk.gui.dialog;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.StringTokenizer;
import kirk.gui.closer.WindowCloser;

public abstract class PopupDialog
extends Dialog
implements ActionListener {
    public PopupDialog(Frame owner, String title) {
        super(owner, title, true);
        this.setLayout(null);
        this.setResizable(false);
        this.addWindowListener(new WindowCloser());
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("CLOSE")) {
            this.close();
        }
    }

    protected void close() {
        this.hide();
        this.dispose();
    }

    public void doLayout() {
        this.setSize(this.getPreferredSize());
        this.center();
        super.doLayout();
    }

    protected void center() {
        Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screensize.width - this.getWidth()) / 2, (screensize.height - this.getHeight()) / 2);
    }

    protected String[] convertMessage(String message, int amount) {
        StringTokenizer tokenizer = new StringTokenizer(message, " \t\n\r\f", true);
        ArrayList<String> lines = new ArrayList<String>();
        String token = null;
        StringBuffer line = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (line.length() + token.length() > amount) {
                lines.add(line.toString());
                line = new StringBuffer(token);
                continue;
            }
            line.append(token);
        }
        lines.add(line.toString());
        return lines.toArray(new String[0]);
    }
}

