// t3h p4ck4g3.
package kirk.gui;

// Import the GUI and event stuff.
import java.awt.*;
import java.awt.event.*;

/**
 * This class closes Windows that generate WindowEvents asking for it.
 *
 * @author Berend Wouda
 * @version 1
 */
public class WindowCloser extends WindowAdapter {
	/**
	 * Closes the passed Window.
	 * 
	 * @param event The event that indicates which Window to close.
	 */
	public void windowClosing(WindowEvent event) {
		// Retrieve the Window.
		Window window = event.getWindow();
		
		// Hide the Window.
		window.setVisible(false);
		
		// Dump the Window.
		window.dispose();
	}
}