// The package of this claz.
package kirk.gui;

// Import the GUI and event stuff.
import java.awt.*;
import java.awt.event.*;

/**
 * Shows a dialog with the given message.
 *
 * @author Berend Wouda
 * @version 1
 */
public class PopupDialog extends Dialog implements ActionListener {
	/**
	 * Constructs a new PopupDialog.
	 * 
	 * @param owner The owner of this Dialog.
	 * @param title The title of this Dialog.
	 * @param message The message to be popped up.
	 */
	public PopupDialog(Frame owner, String title, String message) {
		// Call the supercontructor, with owner, "Error" as title and true for
		// "modal" (blocks input to the owner frame while this Dialog is open).
		super(owner, title, true);
		
		// Set the layout to LineLayout.
		setLayout(new VariableLineLayout());
		
		// Display the message (and center it).
		add(new Label(message, Label.CENTER));
		
		// Add an OK button to this Dialog. Make it close the window by generating an
		// ActionEvent. We will put it on a seperate panel so that it centers.
		Button okButton = new Button("OK");
		okButton.addActionListener(this);
		Panel okPanel = new Panel();
		okPanel.add(okButton);
		add(okPanel);
		
		// Set the windowsize to the preferred size required by the components.
		// AAARGH! Is there ANY way to make this work?
//		Dimension windowsize = getPreferredSize(); 
//		setSize(windowsize.width, windowsize.height);
		setSize(1000,100);
				
		// Set it so that the user cannot resize the window.
		setResizable(false);
		
		// Set the location (in the middle of the screen).
		Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
		setLocation((screensize.width - getWidth()) / 2, (screensize.height - getHeight())/ 2);
		
		// This screen has to be closable too, you know.
		addWindowListener(new WindowCloser());
	}


	/**
	 * Closes this Dialog.
	 * 
	 * @param event The unused standard passed ActionEvent.
	 */
	public void actionPerformed(ActionEvent event) {
		// There is only one button that can generate an action event.
		// That means this window can be closed.
		// Hide this Dialog.
		hide();
		
		// Dump this Dialog.
		dispose();
	}
}