/*
 * Decompiled with CFR 0.152.
 */
package kirk.util;

import java.util.StringTokenizer;

public class Wildcard {
    protected String wildcard;
    protected char single;
    protected char anyamount;

    public Wildcard(String wildcard, char single, char anyamount) {
        this.wildcard = wildcard;
        this.single = single;
        this.anyamount = anyamount;
    }

    public Wildcard(String wildcard) {
        this(wildcard, '?', '*');
    }

    public boolean test(String line) {
        return this.testSingle(new StringTokenizer(this.getWildcard(), "" + this.single + this.anyamount, true), line, 0);
    }

    protected boolean testSingle(StringTokenizer tokenizer, String line, int index) {
        if (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("" + this.single)) {
                if (index < line.length()) {
                    return this.testSingle(tokenizer, line, ++index);
                }
                return false;
            }
            if (token.equals("" + this.anyamount)) {
                return this.testAnyAmount(tokenizer, line, index);
            }
            if (line.startsWith(token, index)) {
                index += token.length();
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean testAnyAmount(StringTokenizer tokenizer, String line, int index) {
        if (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("" + this.single)) {
                if (index < line.length()) {
                    return this.testAnyAmount(tokenizer, line, ++index);
                }
                return false;
            }
            if (token.equals("" + this.anyamount)) {
                return this.testAnyAmount(tokenizer, line, index);
            }
            int tokenindex = line.indexOf(token, index);
            if (tokenindex >= 0) {
                index = tokenindex + token.length();
                return true;
            }
            return false;
        }
        return true;
    }

    public String getWildcard() {
        return this.wildcard;
    }
}

