/*
 * Decompiled with CFR 0.152.
 */
package kirk.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import kirk.util.Wildcard;
import kirk.util.WriteNotAllowedException;

public class FileLineList {
    protected ArrayList linelist;
    protected boolean writesupported;

    public FileLineList(String filename, boolean writable) throws IOException {
        this.setWritable(writable);
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        String line = reader.readLine();
        while (line != null) {
            this.linelist.add(line);
            line = reader.readLine();
        }
        reader.close();
    }

    public FileLineList(String filename) throws IOException {
        this(filename, false);
    }

    public int getNumberOfLines() {
        return this.linelist.size();
    }

    public boolean contains(String line) {
        return this.linelist.contains(line);
    }

    public int firstIndexOf(String line) {
        return this.linelist.indexOf(line);
    }

    public int lastIndexOf(String line) {
        return this.linelist.lastIndexOf(line);
    }

    public ArrayList getList(String wildcard) {
        ArrayList<String> list = new ArrayList<String>();
        int index = 0;
        while (index < this.getNumberOfLines()) {
            Wildcard selector = new Wildcard(wildcard);
            String line = this.get(index);
            if (selector.test(line)) {
                list.add(line);
            }
            ++index;
        }
        return list;
    }

    public String[] toArray() {
        String[] lines = new String[this.linelist.size()];
        return this.linelist.toArray(lines);
    }

    public String get(int index) {
        return (String)this.linelist.get(index);
    }

    public void add(String line) throws WriteNotAllowedException {
        if (!this.writesupported) {
            throw new WriteNotAllowedException();
        }
        this.linelist.add(line);
    }

    public void insert(String line, int index) throws WriteNotAllowedException {
        if (!this.writesupported) {
            throw new WriteNotAllowedException();
        }
        this.linelist.add(index, line);
    }

    public void replace(int index, String line) throws WriteNotAllowedException {
        if (!this.writesupported) {
            throw new WriteNotAllowedException();
        }
        this.linelist.set(index, line);
    }

    public void append(int index, String line) throws WriteNotAllowedException {
        if (!this.writesupported) {
            throw new WriteNotAllowedException();
        }
        this.replace(index, String.valueOf((String)this.linelist.get(index)) + line);
    }

    public void remove(int index) throws WriteNotAllowedException {
        if (!this.writesupported) {
            throw new WriteNotAllowedException();
        }
        this.linelist.remove(index);
    }

    public void flush(String filename) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
        int index = 0;
        while (index < this.getNumberOfLines() - 1) {
            writer.write(this.get(index));
            writer.newLine();
            ++index;
        }
        writer.write(this.get(this.getNumberOfLines() - 1));
    }

    public boolean isWritable() {
        return this.writesupported;
    }

    protected void setWritable(boolean writable) {
        this.writesupported = writable;
    }
}

