/*
 * Decompiled with CFR 0.152.
 */
package kirk.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public abstract class LineLayout
implements LayoutManager {
    private int horizontalgap;
    private int verticalgap;

    public LineLayout(int horizontalgap, int verticalgap) {
        this.setHorizontalGap(horizontalgap);
        this.setVerticalGap(verticalgap);
    }

    public LineLayout(int verticalgap) {
        this(5, verticalgap);
    }

    public LineLayout() {
        this(5, 5);
    }

    public final int getHorizontalGap() {
        return this.horizontalgap;
    }

    public final void setHorizontalGap(int horizontalgap) {
        if (horizontalgap < 0) {
            throw new IllegalArgumentException("Cannot set horizontal gap: The given horizontal gap is negative.");
        }
        this.horizontalgap = horizontalgap;
    }

    public final int getVerticalGap() {
        return this.verticalgap;
    }

    public final void setVerticalGap(int verticalgap) {
        if (verticalgap < 0) {
            throw new IllegalArgumentException("Cannot set vertical gap: The given vertical gap is negative.");
        }
        this.verticalgap = verticalgap;
    }

    public final void addLayoutComponent(String name, Component comp) {
    }

    public final void removeLayoutComponent(Component comp) {
    }

    public abstract Dimension preferredLayoutSize(Container var1);

    public abstract Dimension minimumLayoutSize(Container var1);

    public abstract void layoutContainer(Container var1);

    public final int getWidth(Container parent, Component component) {
        Insets insets = parent.getInsets();
        int left = insets.left + this.getHorizontalGap();
        int right = insets.right + this.getHorizontalGap();
        if (component.getMaximumSize().width >= parent.getWidth() - left - right) {
            return parent.getWidth() - left - right;
        }
        return component.getPreferredSize().width;
    }

    public final int getPreferredWidth(Container parent) {
        int width = 0;
        int index = 0;
        while (index < parent.getComponentCount()) {
            if (parent.getComponent(index).isVisible()) {
                width = Math.max(parent.getComponent((int)index).getPreferredSize().width, width);
            }
            ++index;
        }
        Insets insets = parent.getInsets();
        return width += this.getHorizontalGap() * 2 + insets.left + insets.right;
    }

    public final int getMinimumWidth(Container parent) {
        int width = 0;
        int index = 0;
        while (index < parent.getComponentCount()) {
            if (parent.getComponent(index).isVisible()) {
                width = Math.max(parent.getComponent((int)index).getMinimumSize().width, width);
            }
            ++index;
        }
        Insets insets = parent.getInsets();
        return width += this.getHorizontalGap() * 2 + insets.left + insets.right;
    }
}

