/*
 * Decompiled with CFR 0.152.
 */
package kirk.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.HashMap;
import kirk.gui.GridSpanConstraints;

public class GridSpanLayout
implements LayoutManager2 {
    protected int width;
    protected int height;
    protected int horizontalgap;
    protected int verticalgap;
    protected HashMap componentmap;

    public GridSpanLayout(int width, int height, int horizontalgap, int verticalgap) {
        this.setWidth(width);
        this.setHeight(height);
        this.setHorizontalGap(horizontalgap);
        this.setVerticalGap(verticalgap);
        this.componentmap = new HashMap();
    }

    public GridSpanLayout(int width, int height) {
        this(width, height, 5, 5);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        if (width <= 0) {
            throw new IllegalArgumentException("Cannot set width: The given width is not positive.");
        }
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        if (height <= 0) {
            throw new IllegalArgumentException("Cannot set height: The given height is not positive.");
        }
        this.height = height;
    }

    public int getHorizontalGap() {
        return this.horizontalgap;
    }

    public void setHorizontalGap(int horizontalgap) {
        if (horizontalgap < 0) {
            throw new IllegalArgumentException("Cannot set horizontal gap: The given horizontal gap is negative.");
        }
        this.horizontalgap = horizontalgap;
    }

    public int getVerticalGap() {
        return this.verticalgap;
    }

    public void setVerticalGap(int verticalgap) {
        if (verticalgap < 0) {
            throw new IllegalArgumentException("Cannot set vertical gap: The given vertical gap is negative.");
        }
        this.verticalgap = verticalgap;
    }

    protected boolean outOfBounds(GridSpanConstraints constraints) {
        if (constraints.getX() < 0) {
            return true;
        }
        if (constraints.getX() + constraints.getWidth() > this.getWidth()) {
            return true;
        }
        if (constraints.getY() < 0) {
            return true;
        }
        return constraints.getY() + constraints.getHeight() > this.getHeight();
    }

    public GridSpanConstraints getConstraints(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("Cannot retrieve the constraints object from the mapping: The given key is null.");
        }
        GridSpanConstraints constraints = (GridSpanConstraints)this.componentmap.get(component);
        if (constraints != null) {
            return (GridSpanConstraints)constraints.clone();
        }
        constraints = new GridSpanConstraints();
        this.setConstraints(component, constraints);
        return (GridSpanConstraints)constraints.clone();
    }

    public GridSpanConstraints setConstraints(Component component, GridSpanConstraints constraints) {
        if (component == null) {
            throw new IllegalArgumentException("Cannot add the constraints object to the mapping: The given key is null.");
        }
        if (constraints == null) {
            return this.componentmap.put(component, new GridSpanConstraints());
        }
        if (this.outOfBounds(constraints)) {
            throw new IllegalArgumentException("Cannot add the constraints object to the mapping: The constraints are out of bounds.");
        }
        return (GridSpanConstraints)this.componentmap.put(component, constraints.clone());
    }

    public GridSpanConstraints removeConstraints(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("Cannot remove the constraints object from the mapping: The given key is null.");
        }
        return (GridSpanConstraints)this.componentmap.remove(component);
    }

    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(comp, null);
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (!(constraints instanceof GridSpanConstraints) && constraints != null) {
            throw new IllegalArgumentException("Cannot add Component to LayoutManager: The given constraints obejct was not an instance of GridSpanConstraints.");
        }
        this.setConstraints(comp, (GridSpanConstraints)constraints);
    }

    public void removeLayoutComponent(Component comp) {
        this.removeConstraints(comp);
    }

    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Component component;
            Component[][] componentgrid = this.makeGrid(parent, false);
            Integer[][] cellwidths = new Integer[this.getWidth()][this.getHeight()];
            Integer[][] cellheights = new Integer[this.getWidth()][this.getHeight()];
            int row = 0;
            while (row < this.getHeight()) {
                int column = 0;
                while (column < this.getWidth()) {
                    component = componentgrid[column][row];
                    cellwidths[column][row] = column == this.getWidth() - 1 || componentgrid[row][column + 1] != component ? new Integer(component.getPreferredSize().width) : null;
                    ++column;
                }
                ++row;
            }
            int column = 0;
            while (column < this.getWidth()) {
                int row2 = 0;
                while (row2 < this.getHeight()) {
                    component = componentgrid[column][row2];
                    if (row2 == this.getHeight() - 1 || componentgrid[row2 + 1][column] != component) {
                        cellheights[column][row2] = new Integer(component.getPreferredSize().height);
                    }
                    cellheights[column][row2] = null;
                    ++row2;
                }
                ++column;
            }
            Insets insets = parent.getInsets();
            return new Dimension(this.getGridWidth(cellwidths) + this.getWidth() * (this.getHorizontalGap() + 1) + insets.left + insets.right, this.getGridHeight(cellheights) + this.getHeight() * (this.getVerticalGap() + 1) + insets.top + insets.bottom);
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Component component;
            Component[][] componentgrid = this.makeGrid(parent, false);
            Integer[][] cellwidths = new Integer[this.getWidth()][this.getHeight()];
            Integer[][] cellheights = new Integer[this.getWidth()][this.getHeight()];
            int row = 0;
            while (row < this.getHeight()) {
                int column = 0;
                while (column < this.getWidth()) {
                    component = componentgrid[column][row];
                    if (column == this.getWidth() - 1 || componentgrid[row][column + 1] != component) {
                        cellwidths[column][row] = new Integer(component.getMinimumSize().width);
                    }
                    cellwidths[column][row] = null;
                    ++column;
                }
                ++row;
            }
            int column = 0;
            while (column < this.getWidth()) {
                int row2 = 0;
                while (row2 < this.getHeight()) {
                    component = componentgrid[column][row2];
                    if (row2 == this.getHeight() - 1 || componentgrid[row2 + 1][column] != component) {
                        cellheights[column][row2] = new Integer(component.getMinimumSize().height);
                    }
                    cellheights[column][row2] = null;
                    ++row2;
                }
                ++column;
            }
            Insets insets = parent.getInsets();
            return new Dimension(this.getGridWidth(cellwidths) + this.getWidth() * (this.getHorizontalGap() + 1) + insets.left + insets.right, this.getGridHeight(cellheights) + this.getHeight() * (this.getVerticalGap() + 1) + insets.top + insets.bottom);
        }
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }

    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Component[][] componentgrid = this.makeGrid(parent, true);
            Dimension parentsize = parent.getSize();
            Insets insets = parent.getInsets();
            int gridwidth = parentsize.width - insets.right - insets.left - this.getHorizontalGap();
            int gridheight = parentsize.height - insets.bottom - insets.top - this.getVerticalGap();
            int top = insets.left + this.getHorizontalGap();
            int left = insets.top + this.getVerticalGap();
            int cellwidth = gridwidth / this.getWidth() - this.getHorizontalGap();
            int cellheight = gridheight / this.getHeight() - this.getVerticalGap();
            ArrayList<Component> componentlist = new ArrayList<Component>();
            int row = 0;
            while (row < this.getHeight()) {
                int column = 0;
                while (column < this.getWidth()) {
                    Component component = componentgrid[column][row];
                    if (component != null && !componentlist.contains(component)) {
                        componentlist.add(component);
                        GridSpanConstraints constraints = this.getConstraints(component);
                        int spannedwidth = (cellwidth + this.getHorizontalGap()) * constraints.getWidth() - this.getHorizontalGap();
                        double horizontalfill = constraints.getHorizontalFill();
                        int width = horizontalfill < 0.0 || horizontalfill > 1.0 ? Math.min(component.getPreferredSize().width, spannedwidth) : (int)(horizontalfill * (double)spannedwidth);
                        int spannedheight = (cellheight + this.getVerticalGap()) * constraints.getHeight() - this.getVerticalGap();
                        double verticalfill = constraints.getVerticalFill();
                        int height = verticalfill < 0.0 || verticalfill > 1.0 ? Math.min(component.getPreferredSize().height, spannedheight) : (int)(horizontalfill * (double)spannedheight);
                        double horizontalanchor = constraints.getHorizontalAnchor();
                        if (horizontalanchor < 0.0 || horizontalanchor > 1.0) {
                            horizontalanchor = component.getAlignmentX();
                        }
                        double horizontalposition = horizontalanchor * (double)(spannedwidth - width);
                        int x = left + column * (cellwidth + this.getHorizontalGap()) + (int)horizontalposition;
                        double verticalanchor = constraints.getVerticalAnchor();
                        if (verticalanchor < 0.0 || verticalanchor > 1.0) {
                            verticalanchor = component.getAlignmentY();
                        }
                        double verticalposition = verticalanchor * (double)(spannedheight - height);
                        int y = top + row * (cellheight + this.getVerticalGap()) + (int)verticalposition;
                        component.setBounds(x, y, width, height);
                    }
                    ++column;
                }
                ++row;
            }
        }
    }

    protected Component[][] makeGrid(Container parent, boolean active) {
        Component[][] componentgrid = new Component[this.getWidth()][this.getHeight()];
        int index = 0;
        while (index < parent.getComponentCount()) {
            Component component = parent.getComponent(index);
            if (component.isVisible()) {
                GridSpanConstraints constraints = this.getConstraints(component);
                if (this.isFree(componentgrid, constraints.getX(), constraints.getY(), constraints.getWidth(), constraints.getHeight())) {
                    this.setTaken(componentgrid, constraints.getX(), constraints.getY(), constraints.getWidth(), constraints.getHeight(), component);
                } else if (active) {
                    component.setBounds(0, 0, 0, 0);
                }
            }
            ++index;
        }
        return componentgrid;
    }

    protected boolean isFree(Component[][] componentgrid, int x, int y, int width, int height) {
        int row = y;
        while (row < y + height) {
            int column = x;
            while (column < x + width) {
                if (componentgrid[column][row] != null) {
                    return false;
                }
                ++column;
            }
            ++row;
        }
        return true;
    }

    protected void setTaken(Component[][] componentgrid, int x, int y, int width, int height, Component component) {
        int row = y;
        while (row < y + height) {
            int column = x;
            while (column < x + width) {
                componentgrid[column][row] = component;
                ++column;
            }
            ++row;
        }
    }

    protected int getGridWidth(Integer[][] cellwidths) {
        int width = 0;
        int column = 0;
        while (column < this.getWidth()) {
            width += this.getLargestWidth(cellwidths, column);
            ++column;
        }
        return width;
    }

    protected int getLargestWidth(Integer[][] cellwidths, int column) {
        int largestwidth = 0;
        int row = 0;
        while (row < this.getHeight()) {
            Integer cellwidth = cellwidths[column][row];
            int comparationwidth = 0;
            if (cellwidth != null) {
                comparationwidth = cellwidth;
                int index = column - 1;
                while (index >= 0 && cellwidths[row][index] == null) {
                    comparationwidth -= this.getLargestWidth(cellwidths, index);
                    --index;
                }
            }
            largestwidth = Math.max(comparationwidth, largestwidth);
            ++row;
        }
        return largestwidth;
    }

    protected int getGridHeight(Integer[][] cellheights) {
        int height = 0;
        int row = 0;
        while (row < this.getHeight()) {
            height += this.getLargestHeight(cellheights, row);
            ++row;
        }
        return height;
    }

    protected int getLargestHeight(Integer[][] cellheights, int row) {
        int largestheight = 0;
        int column = 0;
        while (column < this.getWidth()) {
            Integer cellheight = cellheights[column][row];
            int comparationheight = 0;
            if (cellheight != null) {
                comparationheight = cellheight;
                int index = column - 1;
                while (index >= 0 && cellheights[row][index] == null) {
                    comparationheight -= this.getLargestHeight(cellheights, index);
                    --index;
                }
            }
            largestheight = Math.max(comparationheight, largestheight);
            ++column;
        }
        return largestheight;
    }
}

