/*
 * Copyright 2004 Berend "Kirk" Wouda
 * 
 * This file is part of GPL'd.
 * 
 * GPL'd is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * GPL'd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GPL'd; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


// The package.
package gui;

// Import the AWT classes.
import java.awt.*;

// Import the control class.
import system.GPLdControl;

// Import the Layout Manager.
import kirk.gui.layout.*;

// Import the window closer.
import kirk.gui.closer.WindowCloser;

// Import the ErrorDialog class.
import kirk.gui.dialog.ErrorDialog;

/**
 * This class is the main window of GPL'd.
 * 
 * @author Berend "Kirk" Wouda
 * @version 1.00
 * @since 1.00
 */
public class GPLdFrame extends Frame {
	/**
	 * Constructs a new <code>GPLdFrame</code>.
	 */
	public GPLdFrame() {
		// Super some stuff.
		super("GPL'd v1.00");
		
		// Set the control class.
		control = new GPLdControl(this);

		// Make the window closable using a WindowCloser. Set it to exit the program
		// on closing.
		addWindowListener(new WindowCloser(true));
		
		// Set the size of this window to 400x500.
		setSize(400, 500);
		
		// Make the window unresizable.
		setResizable(false);
		
		// Set the location (in the middle of the screen).
		Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
		setLocation((screensize.width - getWidth()) / 2, (screensize.height - getHeight())/ 2);
		
		// Set the layout to a 6x16 GridSpanLayout with 5 pixel gaps.
		setLayout(new GridSpanLayout(6, 16, 5, 5));
		
		// The constraints used for adding.
		GridSpanConstraints constraints;
		
		// Add the source folder label.
		constraints = new GridSpanConstraints();
		constraints.setX(0);
		constraints.setY(0);
		constraints.setWidth(2);
		constraints.setHeight(1);
		constraints.setHorizontalAnchor(0.0);
		Label folderlabel = new Label("Source Folder:", Label.LEFT);
		add(folderlabel, constraints);
		
		// Add the source folder field.
		constraints = new GridSpanConstraints();
		constraints.setX(2);
		constraints.setY(0);
		constraints.setWidth(3);
		constraints.setHeight(1);
		constraints.setHorizontalFill(1.0);
		folderfield = new TextField();
		add(folderfield, constraints);
		
		// Add the source folder browse button.
		constraints = new GridSpanConstraints();
		constraints.setX(5);
		constraints.setY(0);
		constraints.setWidth(1);
		constraints.setHeight(1);
		Button folderbrowsebutton = new Button("Browse...");
		folderbrowsebutton.setActionCommand("BROWSEFOLDER");
		folderbrowsebutton.addActionListener(control);
		add(folderbrowsebutton, constraints);
		
		// Add the source file extension label.
		constraints = new GridSpanConstraints();
		constraints.setX(0);
		constraints.setY(1);
		constraints.setWidth(2);
		constraints.setHeight(1);
		constraints.setHorizontalAnchor(0.0);
		Label extensionlabel = new Label("Source File Extension:", Label.LEFT);
		add(extensionlabel, constraints);
		
		// Add the source file extension field.
		constraints = new GridSpanConstraints();
		constraints.setX(2);
		constraints.setY(1);
		constraints.setWidth(3);
		constraints.setHeight(1);
		constraints.setHorizontalAnchor(0.0);
		extensionfield = new TextField("java", 4);
		add(extensionfield, constraints);
		
		// Add the program name label.
		constraints = new GridSpanConstraints();
		constraints.setX(0);
		constraints.setY(3);
		constraints.setWidth(2);
		constraints.setHeight(1);
		constraints.setHorizontalAnchor(0.0);
		Label programnamelabel = new Label("Program Name:", Label.LEFT);
		add(programnamelabel, constraints);
		
		// Add the program name field.
		constraints = new GridSpanConstraints();
		constraints.setX(2);
		constraints.setY(3);
		constraints.setWidth(4);
		constraints.setHeight(1);
		constraints.setHorizontalFill(1.0);
		programnamefield = new TextField();
		add(programnamefield, constraints);
		
		// Add the copyright year label.
		constraints = new GridSpanConstraints();
		constraints.setX(0);
		constraints.setY(5);
		constraints.setWidth(2);
		constraints.setHeight(1);
		constraints.setHorizontalAnchor(0.0);
		Label copyrightyearlabel = new Label("Copyright Year:", Label.LEFT);
		add(copyrightyearlabel, constraints);
		
		// Add the copyright year field.
		constraints = new GridSpanConstraints();
		constraints.setX(2);
		constraints.setY(5);
		constraints.setWidth(4);
		constraints.setHeight(1);
		constraints.setHorizontalFill(1.0);
		copyrightyearfield = new TextField("2004");
		add(copyrightyearfield, constraints);
		
		// Add the copyright name label.
		constraints = new GridSpanConstraints();
		constraints.setX(0);
		constraints.setY(6);
		constraints.setWidth(2);
		constraints.setHeight(1);
		constraints.setHorizontalAnchor(0.0);
		Label copyrightnamelabel = new Label("Copyright Name:", Label.LEFT);
		add(copyrightnamelabel, constraints);
		
		// Add the copyright name field.
		constraints = new GridSpanConstraints();
		constraints.setX(2);
		constraints.setY(6);
		constraints.setWidth(4);
		constraints.setHeight(1);
		constraints.setHorizontalFill(1.0);
		copyrightnamefield = new TextField("Berend \"Kirk\" Wouda");
		add(copyrightnamefield, constraints);
		
		// Add the start comment tag label.
		constraints = new GridSpanConstraints();
		constraints.setX(0);
		constraints.setY(8);
		constraints.setWidth(2);
		constraints.setHeight(1);
		constraints.setHorizontalAnchor(0.0);
		Label startcommenttaglabel = new Label("Start Comment Tag:", Label.LEFT);
		add(startcommenttaglabel, constraints);
		
		// Add the start comment tag field.
		constraints = new GridSpanConstraints();
		constraints.setX(2);
		constraints.setY(8);
		constraints.setWidth(1);
		constraints.setHeight(1);
		constraints.setHorizontalAnchor(0.0);
		startcommenttagfield = new TextField("/*", 3);
		add(startcommenttagfield, constraints);
		
		// Add the comment inset label.
		constraints = new GridSpanConstraints();
		constraints.setX(0);
		constraints.setY(9);
		constraints.setWidth(2);
		constraints.setHeight(1);
		constraints.setHorizontalAnchor(0.0);
		Label commentinsetlabel = new Label("Comment Inset:", Label.LEFT);
		add(commentinsetlabel, constraints);
		
		// Add the comment inset field.
		constraints = new GridSpanConstraints();
		constraints.setX(2);
		constraints.setY(9);
		constraints.setWidth(1);
		constraints.setHeight(1);
		constraints.setHorizontalAnchor(0.0);
		commentinsetfield = new TextField(" * ", 3);
		add(commentinsetfield, constraints);
		
		// Add the end comment tag label.
		constraints = new GridSpanConstraints();
		constraints.setX(0);
		constraints.setY(10);
		constraints.setWidth(2);
		constraints.setHeight(1);
		constraints.setHorizontalAnchor(0.0);
		Label endcommenttaglabel = new Label("End Comment Tag:", Label.LEFT);
		add(endcommenttaglabel, constraints);
		
		// Add the end comment tag field.
		constraints = new GridSpanConstraints();
		constraints.setX(2);
		constraints.setY(10);
		constraints.setWidth(1);
		constraints.setHeight(1);
		constraints.setHorizontalAnchor(0.0);
		endcommenttagfield = new TextField(" */", 3);
		add(endcommenttagfield, constraints);
		
		// Add the multiline program option.
		constraints = new GridSpanConstraints();
		constraints.setX(0);
		constraints.setY(12);
		constraints.setWidth(3);
		constraints.setHeight(1);
		constraints.setHorizontalAnchor(0.0);
		multifileprogramoption = new Checkbox("Multifile Program", true);
		add(multifileprogramoption, constraints);
		
		// Add the multiline program option.
		constraints = new GridSpanConstraints();
		constraints.setX(0);
		constraints.setY(13);
		constraints.setWidth(3);
		constraints.setHeight(1);
		constraints.setHorizontalAnchor(0.0);
		recursiveoption = new Checkbox("Include Subfolders", true);
		add(recursiveoption, constraints);
		
		// Add the license file label.
		constraints = new GridSpanConstraints();
		constraints.setX(0);
		constraints.setY(15);
		constraints.setWidth(2);
		constraints.setHeight(1);
		constraints.setHorizontalAnchor(0.0);
		Label licensefilelabel = new Label("License File:", Label.LEFT);
		add(licensefilelabel, constraints);
		
		// Add the license file field.
		constraints = new GridSpanConstraints();
		constraints.setX(2);
		constraints.setY(15);
		constraints.setWidth(3);
		constraints.setHeight(1);
		constraints.setHorizontalFill(1.0);
		licensefilefield = new TextField("..\\Source Licenses\\GPL.txt");
		add(licensefilefield, constraints);
		
		// Add the license file browse button.
		constraints = new GridSpanConstraints();
		constraints.setX(5);
		constraints.setY(15);
		constraints.setWidth(1);
		constraints.setHeight(1);
		Button licensefilebrowsebutton = new Button("Browse...");
		licensefilebrowsebutton.setActionCommand("BROWSELICENSE");
		licensefilebrowsebutton.addActionListener(control);
		add(licensefilebrowsebutton, constraints);
		
		// Add the start button button.
		constraints = new GridSpanConstraints();
		constraints.setX(3);
		constraints.setY(8);
		constraints.setWidth(3);
		constraints.setHeight(7);
		constraints.setHorizontalAnchor(0.8);
		constraints.setVerticalAnchor(0.9);
		constraints.setHorizontalFill(0.6);
		constraints.setVerticalFill(0.4);
		Button startbutton = new Button("Start!");
		startbutton.setFont(new Font("Default", Font.BOLD, 35));
		startbutton.setActionCommand("START");
		startbutton.addActionListener(control);
		add(startbutton, constraints);
		
		// Make the window visible.
		setVisible(true);
	}
	
	
	/**
	 * Shows a Dialog with the passed message.
	 * 
	 * @param message the passed message.
	 */
	public void popup(String message) {
		// Create a Dialog that is going to show the message.
		ErrorDialog popup = new ErrorDialog(this, message);
		
		// Show this dialog (that will also block this method until it is closed). 
		popup.show();
	}
	
	
	/**
	 * Pops up a <code>FileDialog</code> and returns the selected folder.
	 * 
	 * @return The selected foldername.
	 */
	public String askForFolderSelection() {
		// Create a new FileDialog.
		FileDialog selection = new FileDialog(this, "Please select a folder...", FileDialog.LOAD);
		
		// Show0r me.
		selection.show();
		
		// When we get here the user closed the selection dialog. Time to retrieve
		// the foldername!
		String dir = selection.getDirectory();
		 
		// If the dialog was canceled there won't be any strings, but null values.
		// We need to parry this.
		if(dir == null)  dir = "";
		
		// Return the foldername. 
		return dir;
	}
	
	/**
	 * Pops up a <code>FileDialog</code> and returns the selected license file.
	 * 
	 * @return The selected license filename.
	 */
	public String askForLicenseFileSelection() {
		// Create a new FileDialog.
		FileDialog selection = new FileDialog(this, "Please select a license file...", FileDialog.LOAD);
		
		// Show0r me.
		selection.show();
		
		// When we get here the user closed the selection dialog. Time to retrieve
		// the filename!
		String dir = selection.getDirectory();
		String file = selection.getFile();
		 
		// If the dialog was canceled there won't be any strings, but null values.
		// We need to parry this.
		if(dir == null)  dir = "";
		if(file == null)  file = "";
		
		// Return the path.
		return dir + file;
	}
	
	
	/**
	 * Returns the source folder name.
	 * 
	 * @return The source folder name.
	 */
	public String getFoldername() {
		// Return the folder name.
		return folderfield.getText();
	}
	
	/**
	 * Sets the source folder name.
	 * 
	 * @param foldername The new source folder name.
	 */
	public void setFoldername(String foldername) {
		// Set the source folder name.
		folderfield.setText(foldername);
	}
	
	/**
	 * Returns the source file extension name.
	 * 
	 * @return The source file extension folder name.
	 */
	public String getExtension() {
		// Return the source file extension.
		return extensionfield.getText();
	}
	
	/**
	 * Returns the program name.
	 * 
	 * @return The program name.
	 */
	public String getProgramName() {
		// Return the program name.
		return programnamefield.getText();
	}

	/**
	 * Returns the copyright year.
	 * 
	 * @return The copyright year.
	 */
	public String getCopyrightYear() {
		// Return the copyright year.
		return copyrightyearfield.getText();
	}

	/**
	 * Returns the copyright name.
	 * 
	 * @return The copyright name.
	 */
	public String getCopyrightName() {
		// Return the copyright name.
		return copyrightnamefield.getText();
	}
	
	/**
	 * Returns the start comment tag.
	 * 
	 * @return The start comment tag.
	 */
	public String getStartCommentTag() {
		// Return the start comment tag.
		return startcommenttagfield.getText();
	}
	
	/**
	 * Returns the comment inset.
	 * 
	 * @return The comment inset.
	 */
	public String getCommentInset() {
		// Return the comment inset.
		return commentinsetfield.getText();
	}
	
	/**
	 * Returns the end comment tag.
	 * 
	 * @return The end comment tag.
	 */
	public String getEndCommentTag() {
		// Return the end comment tag.
		return endcommenttagfield.getText();
	}

	/**
	 * Returns the multifile program setting.
	 * 
	 * @return The multifile program setting.
	 */
	public boolean getMultiFileProgram() {
		// Return the multifile program setting.
		return multifileprogramoption.getState();
	}

	/**
	 * Returns the recursive setting.
	 * 
	 * @return The recursive setting.
	 */
	public boolean getRecursive() {
		// Return the recursive setting.
		return recursiveoption.getState();
	}
	
	/**
	 * Returns the license filename.
	 * 
	 * @return The license filename.
	 */
	public String getLicenseFilename() {
		// Return the license filename.
		return licensefilefield.getText();
	}
	
	/**
	 * Sets the license filename.
	 * 
	 * @param filename The new license filename.
	 */
	public void setLicenseFilename(String filename) {
		// Set the license filename.
		licensefilefield.setText(filename);
	}

	
	/**
	 * The field with the folder name in it.
	 */
	protected TextField folderfield;
	
	/**
	 * The field with the source file extension in it.
	 */
	protected TextField extensionfield;
	
	/**
	 * The field with the program name in it.
	 */
	protected TextField programnamefield;

	/**
	 * The field with the copyright year in it.
	 */
	protected TextField copyrightyearfield;
	
	/**
	 * The field with the copyright name in it.
	 */
	protected TextField copyrightnamefield;
	
	/**
	 * The field with the start comment tag in it.
	 */
	protected TextField startcommenttagfield;
	
	/**
	 * The field with the comment inset in it.
	 */
	protected TextField commentinsetfield;
	
	/**
	 * The field with the end comment tag in it.
	 */
	protected TextField endcommenttagfield;
	
	/**
	 * The option for multifile programs.
	 */
	protected Checkbox multifileprogramoption;
	
	/**
	 * The option for resursive editing.
	 */
	protected Checkbox recursiveoption;

	/**
	 * The field with the license file in it.
	 */
	protected TextField licensefilefield;	
	
	/**
	 * The control class going with this GUI.
	 */
	protected GPLdControl control;
}